******************************************************************************
*                        680xx Grundprogramm floppy                          *
*                        (C) 1990 Ralph Dombrowski                           *
*                            2008 Jens Mewes                                 *
*                                Rev 7.10                                    *
*                               01.01.2008                                   *
*                            Floppy-Routinen                                 *
******************************************************************************


flinit:
 movem.l d0/a0,-(a7)
 move.b #$80,steprate(a5)       * Steprate auf den schnellsten Wert
 st drvat(a5)                   * Kein altes Laufwerk gltig
 lea drvtab(a5),a0              * Spurtabelle der Laufwerke
 moveq #16-1,d0
flinitlp:
 st (a0)+                       * Laufwerkstabellen entwerten
dbra d0,flinitlp
 move.b #$60,flo4.w             * Floppy-Motoren aus
 movem.l (a7)+,d0/a0
rts

getflop:                        * Floppyformat feststellen d4=Laufwerksnummer
 tst.b flo2srd(a5)              * Floppy nach SRAMDISK aktiv?
 beq.s getaflop                 * Nein
 btst.b #3, d4                  * Floppy4 angesprochen?
 bne flook                      * Ja!, dann fertig ;)
getaflop:
 move.b #$d0,flo0.w             * Controller rcksetzen
 tst.b flo0.w                   * Interrupts lschen
 and.b #$8f,d4                  * Nur Seitenbit und Laufwerkscodierung lassen
 bsr wawa
 or.b #%00110000,d4
 bsr.s get1flop                 * Mini SD
 bcc flook
 and.b #%10101111,d4
 bsr.s get1flop                 * Mini DD
 bcc flook
 eori.b #%00110000,d4
 bsr.s get1flop                 * Maxi SD
 bcc flook
 and.b #%10001111,d4            * Maxi DD

get1flop:
 move.b d4,flo4.w               * Laufwerkscode bertragen
 move.b steprate(a5),d0
 and.b #3,d0                    * Geschwindigkeit
 add.b #$c,d0
 move.b d0,flo0.w               * Restore mit Verify und Headload
 move.l #100000*cpu, d1         * maximale Wartezeit
get2flop:
 btst.b #6,flo4.w
 bne.s get3flop
 subq.l #1, d1
 bge.s get2flop                 * Warten bis Ready
 move #-1, d0
 clr.l d1
 bra floerr
get3flop:
 clr.l d1
 move.b flo0.w,d0               * Status einlesen und Interrupts lschen
 move.b d0,d1                   * Merken fr Analyse
 and.b #%10011000,d0
 bne floerr
bra flook


* d1 = Befehlscode
*  0 = Steprate setzen (0-7)
*  1 = Sektor lesen     2 = Sektor schreiben
*  3 = Track lesen      4 = Track schreiben
*  5 = Startkopf lesen  6 = Restore
*  7 = Seek             8 = Step in
*  9 = Step out        10 = Statusregister beim letzten Zugriff
* d2 = Sektor (Bei d1 = 3,4,6,8,9 ignoriert)
* d3 = Track oder Steprate + SSO Bit 7  (Bei d1 = 6,8,9 ignoriert)
* d4 = Laufwerkscode

floppy:
 tst.b flo2srd(a5)              * Floppy nach SRAMDISK aktiv?
 beq.s floppy1                  * Nein
 btst.b #3, d4                  * Floppy4 angesprochen?
 bne srdisk                     * Ja!
floppy1:
 movem.l d1-d6/a0-a3,-(a7)
 move sr,-(a7)
 move.l $7c.w,-(a7)             * Interrupt-Ebene 7 Adresse merken
 move.l intlv7(a5),-(a7)        * Ebene 7 im Ram
 lea trap0a(pc),a1              * Sprungadresse fr RTE
 move.l a1,intlv7(a5)           * Adresse ablegen zur Sicherheit
 move.l a1,$7c.w                * Adresse ablegen
 or #%0000011100000000,sr       * Interrupt Level 7 setzen
 move.b #$d0,flo0.w             * Floppy Controler rcksetzen
 tst.b flo0.w                   * Interrupts lschen
 bsr.s softex                   * Befehlsauswertung aufrufen
 move sr,d1                     * Statusregister merken
 move.l (a7)+,intlv7(a5)        * Level 7 zurck
 move.l (a7)+,$7c.w             * Level 7 Adresse zurck
 move (a7)+,sr                  * Statusregister zurck
 move d1,ccr                    * Flags zurck
 movem.l (a7)+,d1-d6/a0-a3      * MOVEM, damit Flags erhalten bleiben
rts

softex:                         * Kernroutine zur Befehlsausfhrung
 btst.b #2,serflag(a5)          * Floppy umgelenkt ?
 beq.s softex4                  * Nein
 cmp #1,d1                      * Lesen ?
 bne.s softex2                  * Nein, weiter
 bsr.s floanser                 * Sektorinformation bertragen
 move #1024-1,d1                * 1024 Zeichen
softex1:
 bsr si                         * Zeichen von serieller Karte holen
 move.b d0,(a0)+                * Abspeichern
dbra d1,softex1
bra flook                       * OK, kein Fehler

softex2:
 cmp #2,d1                      * Schreiben ?
 bne floerr                     * Nein, dann Fehler
 bsr.s floanser                 * Sektorinformation bertragen
 move #1024-1,d1                * 1024 Zeichen
softex3:
 move.b (a0)+,d0                * Zeichen holen
 bsr so                         * An serielle Karte geben
dbra d1,softex3
bra flook                       * OK, kein Fehler

softex4:
 tst.b d1                       * Ausgabe ber Floppy-Karte auf Diskette
 bne.s soft1
 and.b #$87,d3                  * Steprate setzen
 move.b d3,steprate(a5)         * 0..7 erlaubt
rts

floanser:                       * Daten fr serielles Laufwerk
 move.b d1,d0
 bsr so                         * Lesen oder Schreiben
 move.b d2,d0
 bsr so                         * Sektor
 move.b d3,d0
 bsr so                         * Spur
 move.b d4,d0
 and.b #%10001111,d0            * Nur Seite und Laufwerk lassen
bra so                          * Laufwerk und Seite

soft1:
 lea flo3.w,a3                  * Daten-bertragungs-Register
 lea flo4.w,a2                  * Auswahlregister
 move.b d4,(a2)                 * Floppyformat und Laufwerkscode setzen
 moveq #0,d6                    * Keine Fehler bisher
 move.b d4,d5
 and.w #$f,d5                   * Laufwerksnummer
 clr d0
 move.b drvat(a5),d0            * Altes Laufwerks
 cmp.b #$ff,d0
 beq.s notdef                   * Kein altes Laufwerk gltig
 cmp.b d0,d5
 beq.s nurseek                  * Gleiches Laufwerk, dann nur suchen
 lea drvtab(a5),a1
 move.b flo1.w,0(a1,d0.w)       * Alte Spur altes Laufwerk merken
notdef:
 lea drvtab(a5),a1
 move.b 0(a1,d5.w),flo1.w       * Alte Spur aktuelles Laufwerk holen
 lea flo0.w,a1                  * Statusregister
 move.b d5,drvat(a5)            * Aktuelles Laufwerk
 cmp #5,d1
 bhi soft2                      * Extra Befehle
bra.s nur1
nurseek:
 lea flo0.w,a1
 cmp #5,d1                      * Statusregister
 bhi soft2                      * Extra Befehle
 btst.b #5,(a2)
 bne.s nodum                    * Wenn HEAD down, dann kein Dummy Seek
nur1:
 bsr seek                       * Selektiert als Dummy
 tst.b d0
 bmi.s nur1                     * Warten bis Ready
nodum:
 cmp.b #$ff,flo1.w
 beq.s trv1                     * Wenn Track undefiniert, dann Restore
 cmp.b flo1.w,d3
 beq.s sk11                     * Wenn Floppytrack = Aktueller Track, dann kein
trv:                            * Seek
 bsr seek
 and.b #%10010000,d0            * Mgliche Fehler
 beq.s sk11                     * OK
trv1:
 cmp.b #10,d6                   * 10 mal versuchen
 bhi floerr                     * Sonst Fehler
 bsr restore                    * Spur Null anfahren
 addq.b #1,d6
bra.s trv

sk11:
 move.b d2,flo2.w               * Sektor setzen
 moveq #8,d0                    * Sektorenlnge
 tst.b steprate(a5)
 bpl.s set1up                   * SSO nicht gesetzt, dann Seite 0
 tst.b d4
 bpl.s set1up                   * SSO und Seite 1 gesetzt, dann Seite 1
 addq #2,d0                     * Seite 1
set1up:
 btst.b #5,(a2)
 bne.s noset                    * HEAD schon geladen, dann OK
 addq #4,d0                     * Sonst Head laden
noset:
 move.l a0,-(a7)
 cmp #1,d1                      * 1 = Sektor lesen
 beq.s rdflp
 cmp #2,d1                      * 2 = Sektor schreiben
 beq.s wrflp
 eori.b #%01001000,d0           * Bit 6 setzen, Bit 3 lschen
 cmp #4,d1
 bne.s sk12
 or.b #%00010000,d0             * 4 = Track schreiben
bra.s wrflp
sk12:
 cmp #3,d1                      * 5 = Sektorinfo lesen
 bne.s rdflp
 or.b #%00100000,d0             * 3 = Track lesen

rdflp:                          * Sektor, Track oder Sektorinfo lesen
 add.b #$80,d0                  * Bit fr LESEN
 move.b d0,(a1)                 * Befehl ausfhren
rd1:
 move.b (a2),d0                 * Status prfen
 rol.b #1,d0                    * und setzen der Flags
 bmi.s rd1e                     * Lesen beendet durch Interrupt
 bcc.s rd1                      * DRQ noch nicht da
 move.b (a3),(a0)+              * Daten ablegen
 bra.s rd1                      * Bis alles gelesen
rd1e:
 move.b (a1),d0                 * Status einlesen
 or.b #1,d0                     * Befehl Gruppe 2,3
 move.b d0,flosr(a5)            * Status merken
 movea.l (a7)+,a0
 and.b #%10011100,d0            * Mgliche Fehler
 beq flook                      * Alles OK
 and.b #%00010000,d0
 bne trv1                       * Bei Record not found neu suchen
 addq.b #1,d6                   * Sonst Fehlerzahl erhhen
 cmp.b #5,d6
 bcs.s sk11                     * Fnfmal Befehl wiederholen
 cmp.b #10,d6
 bcs trv1                       * Dann Seek ausfhren
bra floerr                      * Erst dann erfolgt Fehlermeldung

wrflp:                          * Sektor oder Track schreiben
 add.b #$a0,d0                  * Bits fr SCHREIBEN
 move.b d0,(a1)                 * Befehl ausfhren
wr1:
 move.b (a2),d0                 * Status prfen
 rol.b #1,d0                    * und Flags setzen
 bmi.s wr1e                     * Interrupt beendet
 bcc.s wr1                      * Kein DRQ vorhanden
 move.b (a0)+,(a3)              * Daten bertragen
 bra.s wr1                      * Bis alles geschrieben
wr1e:
 move.b (a1),d0                 * Status einlesen
 or.b #1,d0                     * Befehl Gruppe 2,3
 move.b d0,flosr(a5)            * Status merken
 movea.l (a7)+,a0
 btst.b #6,d0                   * Schreibschutz ?
 bne floerr                     * Dann gleich Ende
 and.b #%10111100,d0            * Mgliche Fehler
 beq flook
 and.b #%00010000,d0
 bne trv1                       * Bei Record not found neu suchen
 addq.b #1,d6                   * Fehler, also Fehlerflag erhhen
 cmp.b #5,d6
 bcs trv1                       * Bis maximal viermal
bra floerr                      * Dann erst Fehlermeldung

soft2:                          * Auswertung der neuen Befehle
 cmp #10,d1
 beq.s soft4                    * Statusregister lesen
 bhi floerr                     * Befehl grer 10 gibt es nicht
 bsr.s soft3                    * Befehlsauswertung
 and.b #%10011000,d0
 beq flook                      * OK, kein Fehler
 addq.b #1,d6
 cmp.b #5,d6                    * 5 mal probiert ?
 bhi.s soft2                    * Nein, also nochmal versuchen
bra floerr                      * Fehler, Befehl wurde nicht richtig ausgefhrt

soft3:
 cmp #6,d1                      * Restore
 beq.s restore
 cmp #7,d1                      * Seek
 beq.s seek
 bsr.s setstep                  * Steprate setzen, da Schreib-Lesekopf bewegt
 or.b #$58,d0                   * wird
 cmp #8,d1
 beq.s seek1                    * Step in
 or.b #$20,d0
bra.s seek1                     * Step out

soft4:
 moveq #0,d0                    * Langwort gltig
 move.b flosr(a5),d0            * Statusregister fr Fehlerabfrage
rts

setstep:                        * Steprate setzen
 bsr.s wawa                     * Warten
 move.b steprate(a5),d0
 and.b #7,d0                    * Steprate ohne SSO
 cmp.b #4,d0
 bmi.s setstep0                 * Kleiner als 4, dann alte Stepraten
 and.b #3,d0
 cmp #2,d1
 beq.s setstep0                 * Langsam bei SEKTOR SCHREIBEN
 cmp #4,d1
 beq.s setstep0                 * Und bei TRACK SCHREIBEN
 move.b d4,d5                   * Sonst auf
 and.b #$df,d5                  * 8 Zoll
 move.b d5,(a2)                 * Floppy Steprate umschalten
rts                             * Bei schnellem Step ohne Prflesen
setstep0:
 addq.b #4,d0                   * Spur Prfen durch Anlesen
rts

seek:                           * Spur suchen
 bsr.s setstep                  * Steprate setzen
 move.b d3,(a3)                 * Spur setzen
 move.b d2,flo2.w               * Sektor setzen
 or.b #$18,d0                   * Befehl SEEK
seek1:
 move.b d0,(a1)                 * Befehl ausfhren
ready:
 btst.b #6,(a2)
 beq.s ready                    * Warten bis Befehl ausgefhrt
 move.b (a1),d0                 * Status lesen und Interrupts lschen
 and.b #$fe,d0                  * Befehl Gruppe 1
 move.b d0,flosr(a5)            * Status merken
 move.b d4,(a2)                 * Altes Floppyformat setzen
rts

restore:                        * Spur Null anfahren
 bsr.s setstep                  * Steprate setzen
 addq.b #8,d0                   * Befehl RESTORE
bra.s seek1                     * Befehl ausfhren

wawa:                           * Warten, da Floppy Controler nicht so schnell
 move #500*cpu,d0
wawa1:
dbra d0,wawa1
rts

floerr:
 moveq #-1,d0                   * Error Code
bra carset                      * Carry auch setzen

flook:
 moveq #0,d0                    * Kein Fehler
bra carres                      * Carry lschen


                                                                                                                                                                                                                                                                                                                                                                        cmp.b #3,d0                    * Mu zwischen 0 und drei liegen
 bhi tracee
 clr.b flip(a5)                 * Keine Seitenumschaltung mehr
 clr.b flip1(a5)
 move.b d0,viewpage(a5)         * Und einstellen
 bsr aktpage
 bsr trdump                     * Regdump neu
bra tracee

traceet:                        * Tabellieren auf Drucker (an/aus)
 cmp.b #'T',d0
 bne.s traceew
 bchg.b #1,tracflag(a5)         * Umschalten
 bsr trdump                     * Regdump neu
bra tracee

traceew:            